#include <conio.h>
#include "tetris_ficha.h"
#include "tetris_tablero.h"

int fichas_def[][][] = {
   {
      {+0, +0, -1, +0, -1, -1, -1, +1},
      {+0, +0, -1, -1, +0, -1, +1, -1},
      {+0, +0, +1, -1, +1, +0, +1, +1},
      {+0, +0, -1, +1, +0, +1, +1, +1}
   },
   {
      {+0, +0, +1, +0, +1, +1, +0, +1},
      {+0, +0, +0, +1, -1, +1, -1, +0},
      {+0, +0, -1, +0, -1, -1, +0, -1},
      {+0, +0, +0, -1, +1, -1, +1, +0}
   },
   {
      {+0, +0, -1, +0, -1, -1, +0, +1},
      {+0, +0, +0, +1, -1, +1, +1, +0},
      {+0, +0, +0, -1, +1, +0, +1, +1},
      {+0, +0, -1, +1, +0, +1, +1, +0}
   },
   {
      {+0, +0, +0, +1, +1, +0, +1, -1},
      {+0, +0, -1, +0, +0, +1, +1, +1},
      {+0, +0, -1, +0, -1, +1, +0, -1},
      {+0, +0, -1, -1, +0, -1, +1, +0}
   },
   {
      {+0, +0, -1, +0, -2, +0, +1, +0},
      {+0, +0, +0, -2, +0, -1, +0, +1},
      {+0, +0, -1, +0, +1, +0, +2, +0},
      {+0, +0, +0, -1, +0, +1, +0, +2}
   },
   {
      {+0, +0, -1, +0, -1, -1, +1, +0},
      {+0, +0, +0, -1, +1, -1, +0, +1},
      {+0, +0, -1, +0, +1, +0, +1, +1},
      {+0, +0, +0, -1, +0, +1, -1, +1}
   },
   {
      {+0, +0, -1, +0, -1, +1, +1, +0},
      {+0, +0, +0, -1, -1, -1, +0, +1},
      {+0, +0, -1, +0, +1, +0, +1, -1},
      {+0, +0, +0, -1, +0, +1, +1, +1}
   }   
};

unsigned int ficha_estado;
unsigned int ficha_tipo;
unsigned int ficha_rotacion;
unsigned int ficha_c;
unsigned int ficha_f;

void ficha_inicializa(void)
{
   ficha_estado = FICHA_ESTADO_INACTIVA;
   ficha_tipo = 0;
   ficha_rotacion = 0;
   ficha_c = 0;
   ficha_f = 0;
}

void ficha_pinta(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_x;
   int bloque_y;

   textcolor(ficha_color(ficha_tipo));
         
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_x = ficha_c + delta_c + TABLERO_X0;
      bloque_y = ficha_f + delta_f + TABLERO_Y0;
      
      cputcxy(bloque_x, bloque_y, FICHA_CHAR);      
   }
}

void ficha_borra(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_x;
   int bloque_y;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_x = ficha_c + delta_c + TABLERO_X0;
      bloque_y = ficha_f + delta_f + TABLERO_Y0;

      cputcxy(bloque_x, bloque_y, FICHA_ESPACIO);      
   }
}

void ficha_rota_derecha(void)
{
   ficha_rotacion = (ficha_rotacion + 1) % FICHA_ROTACIONES;
}

void ficha_rota_izquierda(void)
{
   ficha_rotacion = (ficha_rotacion - 1) % FICHA_ROTACIONES;
}

void ficha_mueve_derecha(void)
{
   ficha_c = ficha_c + 1;
}

void ficha_mueve_izquierda(void)
{
   ficha_c = ficha_c - 1;
}

void ficha_baja(void)
{
   ficha_f = ficha_f + 1;
}

void ficha_sube(void)
{
   ficha_f = ficha_f - 1;
}

void ficha_inc_tipo(void)
{
   ficha_tipo = (ficha_tipo + 1) % FICHA_TIPOS;         
}

void ficha_pinta_datos(void)
{
   gotoxy(0, 24);
   textcolor(COLOR_WHITE);
   cprintf("E:%u,T:%u,R:%u,C:%u,F:%u     ", ficha_estado, ficha_tipo, ficha_rotacion, ficha_c, ficha_f);
}

int ficha_color(int tipo)
{
   return tipo + 2;
}

int ficha_verifica_nueva(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_c;
   int bloque_f;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_c = ficha_c + delta_c;
      bloque_f = ficha_f + delta_f;      

      if (bloque_f < 0)
         continue;
         
      if (tablero[bloque_c][bloque_f] != TABLERO_VACIO)
         return 0;         
   }
   
   return 1;
}

int ficha_verifica_izquierda(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_nueva_c;
   int bloque_nueva_f;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_nueva_c = ficha_c + delta_c - 1;
      bloque_nueva_f = ficha_f + delta_f;      

      if (bloque_nueva_c < 0)
         return 0;
         
      if (tablero[bloque_nueva_c][bloque_nueva_f] != TABLERO_VACIO)
         return 0;         
   }
   
   return 1;
}

int ficha_verifica_derecha(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_nueva_c;
   int bloque_nueva_f;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_nueva_c = ficha_c + delta_c + 1;
      bloque_nueva_f = ficha_f + delta_f;      

      if (bloque_nueva_c > TABLERO_MAX_C-1)
         return 0;
         
      if (tablero[bloque_nueva_c][bloque_nueva_f] != TABLERO_VACIO)
         return 0;         
   }
   
   return 1;
}

int ficha_verifica_abajo(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_nueva_c;
   int bloque_nueva_f;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_nueva_c = ficha_c + delta_c;
      bloque_nueva_f = ficha_f + delta_f + 1;

      if (bloque_nueva_f > TABLERO_MAX_F-1)
         return 0;
         
      if (tablero[bloque_nueva_c][bloque_nueva_f] != TABLERO_VACIO)
         return 0;
   }
   
   return 1;
}

int ficha_verifica_arriba(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_nueva_c;
   int bloque_nueva_f;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_nueva_c = ficha_c + delta_c;
      bloque_nueva_f = ficha_f + delta_f - 1;

      if (bloque_nueva_f < 0)
         return 0;
         
      if (tablero[bloque_nueva_c][bloque_nueva_f] != TABLERO_VACIO)
         return 0;         
   }
   
   return 1;
}

int ficha_verifica_rotacion_derecha(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_nueva_c;
   int bloque_nueva_f;
   int nueva_rotacion;
   
   nueva_rotacion = (ficha_rotacion + 1) % FICHA_ROTACIONES;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][nueva_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][nueva_rotacion][b];

      bloque_nueva_c = ficha_c + delta_c;
      bloque_nueva_f = ficha_f + delta_f;      

      if (bloque_nueva_c < 0)
         return 0;
      
      if (bloque_nueva_c > TABLERO_MAX_C-1)
         return 0;
      
      if (bloque_nueva_f > TABLERO_MAX_F-1)
         return 0;
         
      if (tablero[bloque_nueva_c][bloque_nueva_f] != TABLERO_VACIO)
         return 0;                        
   }

   return 1;
}

int ficha_verifica_rotacion_izquierda(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_nueva_c;
   int bloque_nueva_f;
   int nueva_rotacion;
   
   nueva_rotacion = (ficha_rotacion - 1) % FICHA_ROTACIONES;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][nueva_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][nueva_rotacion][b];

      bloque_nueva_c = ficha_c + delta_c;
      bloque_nueva_f = ficha_f + delta_f;      

      if (bloque_nueva_c < 0)
         return 0;
      
      if (bloque_nueva_c > TABLERO_MAX_C-1)
         return 0;
      
      if (bloque_nueva_f > TABLERO_MAX_F-1)
         return 0;
         
      if (tablero[bloque_nueva_c][bloque_nueva_f] != TABLERO_VACIO)
         return 0;                        
   }

   return 1;
}

void ficha_copia_a_tablero(void)
{
   int b;
   int delta_c;
   int delta_f;
   int bloque_c;
   int bloque_f;
   
   for (b=0; b<2*FICHA_BLOQUES; b++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][b++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][b];

      bloque_c = ficha_c + delta_c;
      bloque_f = ficha_f + delta_f;      

      tablero[bloque_c][bloque_f] = ficha_tipo;
   }
}
