#include <conio.h>
#include "tetris_tablero.h"
#include "tetris_ficha.h"

int tablero[TABLERO_MAX_C][TABLERO_MAX_F];

extern int lineas;
extern int puntos;
extern int max_puntos;

extern void pinta_puntos(void);

void tablero_inicializa_vacio(void)
{
   int c, f;

   for (c=0; c<TABLERO_MAX_C; c++)
   {
      for (f=0; f<TABLERO_MAX_F; f++)
      {
         tablero[c][f] = TABLERO_VACIO;
      }
   }
}

void tablero_inicializa_contenido(void)
{
   int c, f;

   for (c=0; c<TABLERO_MAX_C; c++)
   {
      for (f=0; f<TABLERO_MAX_F; f++)
      {
         if ((c+f) % (FICHA_TIPOS+1) == 0)
         {
            tablero[c][f] = TABLERO_VACIO;
         }
         else
         {
            tablero[c][f] = (c+f) % FICHA_TIPOS;         
         }
      }
   }
}

void tablero_pinta(void)
{
   int c, f;
   
   for (c=0; c<TABLERO_MAX_C; c++)
   {
      for (f=0; f<TABLERO_MAX_F; f++)
      {
         if (tablero[c][f] == TABLERO_VACIO)
         {
            // textcolor(COLOR_BLACK); // En realidad el espacio no necesita color; deja ver el color del fondo
            cputcxy(c + TABLERO_X0, f + TABLERO_Y0, FICHA_ESPACIO);         
         }
         else
         {
            textcolor(ficha_color(tablero[c][f]));
            cputcxy(c + TABLERO_X0, f + TABLERO_Y0, FICHA_CHAR);
         }
      }
   }
}

void tablero_pinta_borde(void)
{
   tablero_pinta_borde_derecho();
   tablero_pinta_borde_izquierdo();
   //tablero_pinta_borde_superior();
   tablero_pinta_borde_inferior();
}

void tablero_pinta_borde_superior(void)
{
   int x, y;   
   int x_min, x_max;
   int y_min, y_max;
      
   x_min = TABLERO_X0 - 1;
   x_max = TABLERO_X0 + TABLERO_MAX_C;

   y_min = TABLERO_Y0 - 1;
   y_max = TABLERO_Y0 + TABLERO_MAX_F;

   textcolor(COLOR_WHITE);
      
   for (x=x_min; x<=x_max; x++)
   {
         cputcxy(x, y_min, '-');   
   }
}

void tablero_pinta_borde_derecho(void)
{
   int x, y;   
   int x_min, x_max;
   int y_min, y_max;
      
   x_min = TABLERO_X0 - 1;
   x_max = TABLERO_X0 + TABLERO_MAX_C;

   y_min = TABLERO_Y0 - 1;
   y_max = TABLERO_Y0 + TABLERO_MAX_F;

   textcolor(COLOR_WHITE);
      
   for (y=y_min; y<=y_max; y++)
   {
         cputcxy(x_max, y, '|');   
   }
}

void tablero_pinta_borde_inferior(void)
{
   int x, y;   
   int x_min, x_max;
   int y_min, y_max;
      
   x_min = TABLERO_X0 - 1;
   x_max = TABLERO_X0 + TABLERO_MAX_C;

   y_min = TABLERO_Y0 - 1;
   y_max = TABLERO_Y0 + TABLERO_MAX_F;

   textcolor(COLOR_WHITE);
      
   for (x=x_min; x<=x_max; x++)
   {
         cputcxy(x, y_max, '-');   
   }
}

void tablero_pinta_borde_izquierdo(void)
{
   int x, y;   
   int x_min, x_max;
   int y_min, y_max;
      
   x_min = TABLERO_X0 - 1;
   x_max = TABLERO_X0 + TABLERO_MAX_C;

   y_min = TABLERO_Y0 - 1;
   y_max = TABLERO_Y0 + TABLERO_MAX_F;

   textcolor(COLOR_WHITE);
      
   for (y=y_min; y<=y_max; y++)
   {
         cputcxy(x_min, y, '|');   
   }
}

void tablero_pinta_datos(void)
{
   int c, f;
   
   textcolor(COLOR_WHITE);
      
   for (c=0; c<TABLERO_MAX_C; c++)
   {
      for (f=0; f<TABLERO_MAX_F; f++)
      {
         gotoxy(c + 20, f + TABLERO_Y0);
         cprintf("%u", tablero[c][f]);         
      }
   }
}

void tablero_filas_llenas(void)
{
   int c, f;
   int llena;
   int num_llenas;

   num_llenas = 0;
            
   for (f=0; f<TABLERO_MAX_F; f++)
   {
      llena = 1;
         
      for (c=0; c<TABLERO_MAX_C; c++)
      {
         if (tablero[c][f] == TABLERO_VACIO)
         {
            llena = 0;   
            break;
         }
      }
      
      if (llena)
      {
         num_llenas++;
         tablero_colapsa_fila(f);       
         tablero_pinta();
      }
   }
   
   if (num_llenas > 0)
   {
      lineas = lineas + num_llenas;
      puntos = puntos + 10*num_llenas*num_llenas;
      if (puntos > max_puntos)
         max_puntos = puntos;
      pinta_puntos();
   }
}

void tablero_colapsa_fila(int fila)
{
   int c, f;
   
   for (f=fila; f>0; f--)
   {
      for (c=0; c<TABLERO_MAX_C; c++)
      {
         tablero[c][f] = tablero[c][f-1];
      }
   }
}
