// AHORA DEJAMOS QUE EL USUARIO ELIJA EL NIVEL
// EL NIVEL TIENE QUE VER CON EL RETARDO EN LA CAÍDA
// A MAYOR NIVEL, MENOS RETARDO

#include <conio.h>
#include <joystick.h>
#include "tetris_ficha.h"
#include "tetris_joystick.h"
#include "tetris_tablero.h"
#include "tetris_random.h"

void inicializa_juego(void);
void inicializa_partida(void);
void joystick_empezar(void);
void joystick_continuar(void);
void ficha_activa(void);
void ficha_actualiza(void);
void ficha_cae(void);
void ficha_mueve(void);
void retardo(unsigned int ret);
void pinta_puntos(void);

char joy2;

int  ret;
int  nivel;
int  ret_max;

int  lineas;
int  puntos;
int  max_puntos;

void main(void)
{
   inicializa_juego();   

   while(1)
   {
      inicializa_partida();
      
      joystick_empezar();
      
      while(1)
      {
         if (ficha_estado == FICHA_ESTADO_INACTIVA)
         {
            ficha_activa();
            ficha_pinta();
            
            if (!ficha_verifica_nueva())
               break;
         }
         else
         {
            ficha_actualiza();      
         }
      }
      
      joystick_continuar();
   }
}

void inicializa_juego(void)
{
   joystick_inicializa();

   bgcolor(COLOR_BLACK);
   bordercolor(COLOR_BLUE);
   
   max_puntos = 0;
   nivel = 1;
}

void inicializa_partida(void)
{
   clrscr();

   ret = 0;
   
   lineas = 0;
   puntos = 0;
   pinta_puntos();   

   tablero_inicializa_vacio();
   tablero_pinta_borde();
   tablero_pinta();

   ficha_inicializa();
   //ficha_pinta();         
}

void joystick_empezar(void)
{
   textcolor(COLOR_WHITE);

   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 4);
   cprintf("Pulsa ARRIBA/ABAJO");         
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 5);   
   cprintf("para nivel y DISPARO");         
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 6);   
   cprintf("para empezar...");         
   
   while(1)
   {
      joy2 = joystick_lee();

      if (JOY_UP(joy2))   
      {
         nivel++;
         if (nivel > 5)
            nivel = 1; 
         pinta_puntos();
      }   
      else if (JOY_DOWN(joy2))   
      {
         nivel--;
         if (nivel < 1)
            nivel = 5;
         pinta_puntos();                  
      }   
      else if (JOY_BTN_1(joy2))         
      {
         break;
      }
   }

   ret_max = 10 - nivel;
      
   textcolor(COLOR_WHITE);

   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 4);
   cprintf("                  ");         
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 5);   
   cprintf("                    ");         
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 6);   
   cprintf("               ");         
}

void joystick_continuar(void)
{
   textcolor(COLOR_WHITE);
   
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 4);
   cprintf("Pulsa DISPARO");         
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 5);   
   cprintf("para continuar...");         
   
   while(1)
   {
      joy2 = joystick_lee();
      
      if (JOY_BTN_1(joy2))         
         break;
   }
   
   textcolor(COLOR_WHITE);
   
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 4);
   cprintf("             ");            
   gotoxy(TABLERO_X0 + 17, TABLERO_Y0 + 5);   
   cprintf("               ");            
}

void ficha_activa(void)
{
   ficha_estado = FICHA_ESTADO_ACTIVA;
   ficha_tipo = random_min_max(0, FICHA_TIPOS);
   ficha_rotacion = random_min_max(0, FICHA_ROTACIONES);
   ficha_c = random_col(ficha_tipo, ficha_rotacion); // Para afinar todo lo posible la columna en función de tipo de ficha y rotación
   ficha_f = random_fil(ficha_tipo, ficha_rotacion);
}

void ficha_actualiza(void)
{
   ret++;
   
   if (ret == ret_max)
   {
      ficha_cae();
      ret = 0;
   }
   
   ficha_mueve();
}

void ficha_cae(void)
{
   if (ficha_verifica_abajo())
   {        
      ficha_borra();      
      ficha_baja();
      ficha_pinta();      
   }
   else
   {
      ficha_estado = FICHA_ESTADO_INACTIVA;
      ficha_copia_a_tablero();
      tablero_pinta();
      //tablero_pinta_datos();
      
      tablero_filas_llenas();
   }
}

void ficha_mueve(void)
{
   joy2 = joystick_lee();
      
   if (JOY_LEFT(joy2))   
   {
      if (ficha_verifica_izquierda())
      {
         ficha_borra();      
         ficha_mueve_izquierda();
         ficha_pinta();      
      }
   }   
   else if (JOY_RIGHT(joy2))   
   {
      if (ficha_verifica_derecha())
      {  
         ficha_borra();      
         ficha_mueve_derecha();
         ficha_pinta();                                    
      }
   }   
   else if (JOY_UP(joy2))   
   {
//       if (ficha_verifica_arriba())
//       {
//          ficha_borra();      
//          ficha_sube();
//          ficha_pinta();                              
//       }
   }   
   else if (JOY_DOWN(joy2))   
   {
//       if (ficha_verifica_abajo())
//       {        
//          ficha_borra();      
//          ficha_baja();
//          ficha_pinta();                           
//       }
   }   
   else if (JOY_BTN_1(joy2))   
   {
      if (ficha_verifica_rotacion_derecha())
      {  
         ficha_borra();      
         ficha_rota_derecha();
         ficha_pinta();                           
      }
   }   
   
   ficha_pinta_datos();            
}

void retardo(unsigned int ret)
{
   int i;
   
   for (i=0; i<ret; i++)
   {}
}

void pinta_puntos(void)
{
   textcolor(COLOR_WHITE);

   gotoxy(TABLERO_X0 + 20, TABLERO_Y0 + 9);
   cprintf("Nivel : %u     ", nivel);         
   
   gotoxy(TABLERO_X0 + 20, TABLERO_Y0 + 10);
   cprintf("Lineas: %u     ", lineas);         
   
   gotoxy(TABLERO_X0 + 20, TABLERO_Y0 + 11);
   cprintf("Puntos: %u     ", puntos);         
   
   gotoxy(TABLERO_X0 + 20, TABLERO_Y0 + 12);
   cprintf("Maximo: %u     ", max_puntos);            
}

