// AHORA JUNTAMOS EL TABLERO Y LA FICHA

// LA FICHA SE VA A PODER MOVER A IZQD, DCHA Y ABAJO; NO HACIA ARRIBA
// LA FICHA TAMBÍEN SE VA A PODER ROTAR A LA DERECHA

// AL MOVERSE Y AL ROTAR NO PODRÁ SALIRSE DE LOS LÍMITES EL TABLERO

#include <conio.h>
#include <joystick.h>
#include "tetris_ficha.h"
#include "tetris_joystick.h"
#include "tetris_tablero.h"

void inicializa(void);
void actualiza_ficha(void);
void retardo(unsigned int ret);

char joy2;

void main(void)
{
   inicializa();   
   
   while(1)
   {
      actualiza_ficha();      
      retardo(200);
   }
}

void inicializa(void)
{
   joystick_inicializa();

   clrscr();
   bgcolor(COLOR_BLACK);
   bordercolor(COLOR_BLUE);

   tablero_inicializa_vacio();
   tablero_pinta_borde();
   tablero_pinta();
   
   ficha_inicializa();
   ficha_pinta();         
}

void actualiza_ficha(void)
{
   joy2 = joystick_lee();
      
   if (JOY_LEFT(joy2))   
   {
      if (ficha_verifica_izquierda())
      {
         ficha_borra();      
         ficha_mueve_izquierda();
         ficha_pinta();      
      }
   }   
   else if (JOY_RIGHT(joy2))   
   {
      if (ficha_verifica_derecha())
      {  
         ficha_borra();      
         ficha_mueve_derecha();
         ficha_pinta();      
      }
   }   
   else if (JOY_UP(joy2))   
   {
      if (ficha_verifica_arriba())
      {
         ficha_borra();      
         ficha_sube();
         ficha_pinta();      
      }
   }   
   else if (JOY_DOWN(joy2))   
   {
      if (ficha_verifica_abajo())
      {        
         ficha_borra();      
         ficha_baja();
         ficha_pinta();      
      }
   }   
   else if (JOY_BTN_1(joy2))   
   {
      if (ficha_verifica_rotacion_derecha())
      {  
         ficha_borra();      
         ficha_rota_derecha();
         ficha_pinta();
      }
   }   
   
   ficha_datos();                  
}

void retardo(unsigned int ret)
{
   int i;
   
   for (i=0; i<ret; i++)
   {}
}
