// AHORA QUE DETECTAMOS EL FIN DE PARTIDA, DEBEMOS PERMITIR VARIAS PARTIDAS
// ADEMÁS, INTERESA CONTROLAR LA PUNUTACIÓN MÁXIMA DE ESAS PARTIDAS

#include <conio.h>
#include <joystick.h>
#include "tetris_ficha.h"
#include "tetris_joystick.h"
#include "tetris_tablero.h"
#include "tetris_random.h"

void inicializa_juego(void);
void inicializa_partida(void);
void joystick_empezar(void);
void joystick_continuar(void);
void ficha_activa(void);
void ficha_actualiza(void);
void ficha_cae(void);
void ficha_mueve(void);
void retardo(unsigned int ret);

char joy2;
int  ret;

void main(void)
{
   inicializa_juego();   

   while(1)
   {
      inicializa_partida();
      
      joystick_empezar();
      
      while(1)
      {
         if (ficha_estado == FICHA_ESTADO_INACTIVA)
         {
            ficha_activa();
            ficha_pinta();
            
            if (!ficha_verifica_nueva())
               break;
         }
         else
         {
            ficha_actualiza();      
         }
      }
      
      joystick_continuar();
   }
}

void inicializa_juego(void)
{
   joystick_inicializa();

   bgcolor(COLOR_BLACK);
   bordercolor(COLOR_BLUE);
   
   max_puntos = 0;
}

void inicializa_partida(void)
{
   clrscr();
   
   tablero_inicializa_vacio();
   tablero_pinta_borde();
   tablero_pinta();

   tablero_inicializa_puntos();
   tablero_pinta_puntos();
      
   ficha_inicializa();
   //ficha_pinta();         
}

void joystick_empezar(void)
{
   textcolor(COLOR_WHITE);
   
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 5);
   cprintf("Pulsa DISPARO");         
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 6);   
   cprintf("para empezar...");         
   
   while(1)
   {
      joy2 = joystick_lee();
      
      if (JOY_BTN_1(joy2))         
         break;
   }
   
   textcolor(COLOR_WHITE);
   
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 5);
   cprintf("             ");            
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 6);   
   cprintf("               ");            
}

void joystick_continuar(void)
{
   textcolor(COLOR_WHITE);
   
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 6);
   cprintf("Pulsa DISPARO");         
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 7);   
   cprintf("para continuar...");         
   
   while(1)
   {
      joy2 = joystick_lee();
      
      if (JOY_BTN_1(joy2))         
         break;
   }
   
   textcolor(COLOR_WHITE);
   
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 6);
   cprintf("             ");            
   gotoxy(TABLERO_X0 + 18, TABLERO_Y0 + 7);   
   cprintf("               ");            
}

void ficha_activa(void)
{
   ficha_estado = FICHA_ESTADO_ACTIVA;
   ficha_tipo = random_min_max(0, FICHA_TIPOS);
   ficha_rotacion = random_min_max(0, FICHA_ROTACIONES);
   ficha_c = random_col(ficha_tipo, ficha_rotacion); // Para afinar todo lo posible la columna en función de tipo de ficha y rotación
   ficha_f = random_fil(ficha_tipo, ficha_rotacion);
}

void ficha_actualiza(void)
{
   ret++;
   
   if (ret == 10)
   {
      ficha_cae();
      ret = 0;
   }
   
   ficha_mueve();
}

void ficha_cae(void)
{
   if (ficha_verifica_abajo())
   {        
      ficha_borra();      
      ficha_baja();
      ficha_pinta();      
   }
   else
   {
      ficha_estado = FICHA_ESTADO_INACTIVA;
      ficha_copia_a_tablero();
      tablero_pinta();
      //tablero_pinta_datos();
      
      tablero_filas_llenas();
   }
}

void ficha_mueve(void)
{
   joy2 = joystick_lee();
      
   if (JOY_LEFT(joy2))   
   {
      if (ficha_verifica_izquierda())
      {
         ficha_borra();      
         ficha_mueve_izquierda();
         ficha_pinta();      
      }
   }   
   else if (JOY_RIGHT(joy2))   
   {
      if (ficha_verifica_derecha())
      {  
         ficha_borra();      
         ficha_mueve_derecha();
         ficha_pinta();                                    
      }
   }   
   else if (JOY_UP(joy2))   
   {
//       if (ficha_verifica_arriba())
//       {
//          ficha_borra();      
//          ficha_sube();
//          ficha_pinta();                              
//       }
   }   
   else if (JOY_DOWN(joy2))   
   {
//       if (ficha_verifica_abajo())
//       {        
//          ficha_borra();      
//          ficha_baja();
//          ficha_pinta();                           
//       }
   }   
   else if (JOY_BTN_1(joy2))   
   {
      if (ficha_verifica_rotacion_derecha())
      {  
         ficha_borra();      
         ficha_rota_derecha();
         ficha_pinta();                           
      }
   }   
   
   ficha_pinta_datos();            
}

void retardo(unsigned int ret)
{
   int i;
   
   for (i=0; i<ret; i++)
   {}
}
