// AHORA LA PIEZA APARECE ARRIBA Y CAE HASTA LLEGAR AL FONDO, DONDE SE ACUMULA

#include <conio.h>
#include <joystick.h>
#include "tetris_ficha.h"
#include "tetris_joystick.h"
#include "tetris_tablero.h"

void inicializa(void);
void ficha_activa(void);
void ficha_actualiza(void);
void ficha_cae(void);
void ficha_mueve(void);
void retardo(unsigned int ret);

char joy2;
int  ret;

void main(void)
{
   inicializa();   
   
   while(1)
   {
      if (ficha_estado == FICHA_ESTADO_INACTIVA)
      {
         ficha_activa();
      }
      else
      {
         ficha_actualiza();      
      }
   }
}

void inicializa(void)
{
   joystick_inicializa();

   clrscr();
   bgcolor(COLOR_BLACK);
   bordercolor(COLOR_BLUE);

   tablero_inicializa_vacio();
   tablero_pinta_borde();
   tablero_pinta();
   
   ficha_inicializa();
   //ficha_pinta();         
}

void ficha_activa(void)
{
   ficha_estado = FICHA_ESTADO_ACTIVA;
   ficha_tipo = 0;
   ficha_rotacion = 0;
   ficha_c = TABLERO_MAX_C/2;
   ficha_f = 0;   
}

void ficha_actualiza(void)
{
   ret++;
   
   if (ret == 10)
   {
      ficha_cae();
      ret = 0;
   }
   
   ficha_mueve();
}

void ficha_cae(void)
{
   if (ficha_verifica_abajo())
   {        
      ficha_borra();      
      ficha_baja();
      ficha_pinta();      
   }
   else
   {
      ficha_copia_a_tablero();
      ficha_estado = FICHA_ESTADO_INACTIVA;
      tablero_pinta();
      //tablero_pinta_datos();
   }
}

void ficha_mueve(void)
{
   joy2 = joystick_lee();
      
   if (JOY_LEFT(joy2))   
   {
      if (ficha_verifica_izquierda())
      {
         ficha_borra();      
         ficha_mueve_izquierda();
         ficha_pinta();      
      }
   }   
   else if (JOY_RIGHT(joy2))   
   {
      if (ficha_verifica_derecha())
      {  
         ficha_borra();      
         ficha_mueve_derecha();
         ficha_pinta();      
      }
   }   
   else if (JOY_UP(joy2))   
   {
//       if (ficha_verifica_arriba())
//       {
//          ficha_borra();      
//          ficha_sube();
//          ficha_pinta();      
//       }
   }   
   else if (JOY_DOWN(joy2))   
   {
//       if (ficha_verifica_abajo())
//       {        
//          ficha_borra();      
//          ficha_baja();
//          ficha_pinta();      
//       }
   }   
   else if (JOY_BTN_1(joy2))   
   {
      if (ficha_verifica_rotacion_derecha())
      {  
         ficha_borra();      
         ficha_rota_derecha();
         ficha_pinta();
      }
   }   
   
   ficha_datos();                  
}

void retardo(unsigned int ret)
{
   int i;
   
   for (i=0; i<ret; i++)
   {}
}
