#ifndef _TETRIS_FICHA
#define _TETRIS_FICHA

#define FICHA_CHAR 169
#define FICHA_ESPACIO 32

#define FICHA_TIPOS 7
#define FICHA_ROTACIONES 4
#define FICHA_BLOQUES 4

#define FICHA_ESTADO_INACTIVA 0
#define FICHA_ESTADO_ACTIVA 1

extern unsigned int ficha_estado;
extern unsigned int ficha_tipo;
extern unsigned int ficha_rotacion;
extern unsigned int ficha_c;
extern unsigned int ficha_f;

void ficha_inicializa(void);
void ficha_pinta(void);
void ficha_borra(void);
void ficha_rota_derecha(void);
void ficha_rota_izquierda(void);
void ficha_mueve_derecha(void);
void ficha_mueve_izquierda(void);
void ficha_baja(void);
void ficha_sube(void);
void ficha_inc_tipo(void);
void ficha_pinta_datos(void);
int  ficha_color(int tipo);
int  ficha_verifica_nueva(void);
int  ficha_verifica_izquierda(void);
int  ficha_verifica_derecha(void);
int  ficha_verifica_abajo(void);
int  ficha_verifica_arriba(void);
int  ficha_verifica_rotacion_izquierda(void);
int  ficha_verifica_rotacion_derecha(void);
void ficha_copia_a_tablero(void);

#endif
