#include <conio.h>
#include "tetris_ficha.h"

int fichas_def[][][] = {
   {
      {+0, +0, -1, +0, -1, -1, -1, +1},
      {+0, +0, -1, -1, +0, -1, +1, -1},
      {+0, +0, +1, -1, +1, +0, +1, +1},
      {+0, +0, -1, +1, +0, +1, +1, +1}
   },
   {
      {+0, +0, +1, +0, +1, +1, +0, +1},
      {+0, +0, +0, +1, -1, +1, -1, +0},
      {+0, +0, -1, +0, -1, -1, +0, -1},
      {+0, +0, +0, -1, +1, -1, +1, +0}
   },
   {
      {+0, +0, -1, +0, -1, -1, +0, +1},
      {+0, +0, +0, +1, -1, +1, +1, +0},
      {+0, +0, +0, -1, +1, +0, +1, +1},
      {+0, +0, -1, +1, +0, +1, +1, +0}
   },
   {
      {+0, +0, +0, +1, +1, +0, +1, -1},
      {+0, +0, -1, +0, +0, +1, +1, +1},
      {+0, +0, -1, +0, -1, +1, +0, -1},
      {+0, +0, -1, -1, +0, -1, +1, +0}
   },
   {
      {+0, +0, -1, +0, -2, +0, +1, +0},
      {+0, +0, +0, -2, +0, -1, +0, +1},
      {+0, +0, -1, +0, +1, +0, +2, +0},
      {+0, +0, +0, -1, +0, +1, +0, +2}
   },
   {
      {+0, +0, -1, +0, -1, -1, +1, +0},
      {+0, +0, +0, -1, +1, -1, +0, +1},
      {+0, +0, -1, +0, +1, +0, +1, +1},
      {+0, +0, +0, -1, +0, +1, -1, +1}
   },
   {
      {+0, +0, -1, +0, -1, +1, +1, +0},
      {+0, +0, +0, -1, -1, -1, +0, +1},
      {+0, +0, -1, +0, +1, +0, +1, -1},
      {+0, +0, +0, -1, +0, +1, +1, +1}
   }   
};

unsigned int ficha_estado;
unsigned int ficha_tipo;
unsigned int ficha_rotacion;
unsigned int ficha_c;
unsigned int ficha_f;

void ficha_inicializa(void)
{
   ficha_estado = 1;
   ficha_tipo = 0;
   ficha_rotacion = 0;
   ficha_c = 20;
   ficha_f = 12;
}

void ficha_pinta(void)
{
   int i;
   int delta_c;
   int delta_f;
   
   for (i=0; i<2*FICHA_BLOQUES; i++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][i++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][i];

      cputcxy(ficha_c + delta_c, ficha_f + delta_f, FICHA_CHAR);      
   }
}

void ficha_borra(void)
{
   int i;
   int delta_c;
   int delta_f;
   
   for (i=0; i<2*FICHA_BLOQUES; i++)
   {
      delta_c = fichas_def[ficha_tipo][ficha_rotacion][i++];
      delta_f = fichas_def[ficha_tipo][ficha_rotacion][i];

      cputcxy(ficha_c + delta_c, ficha_f + delta_f, FICHA_ESPACIO);      
   }
}

void ficha_rota_derecha(void)
{
   ficha_rotacion = (ficha_rotacion + 1) % FICHA_ROTACIONES;
}

void ficha_rota_izquierda(void)
{
   ficha_rotacion = (ficha_rotacion - 1) % FICHA_ROTACIONES;
}

void ficha_mueve_derecha(void)
{
   ficha_c = ficha_c + 1;
}

void ficha_mueve_izquierda(void)
{
   ficha_c = ficha_c - 1;
}

void ficha_baja(void)
{
   ficha_f = ficha_f + 1;
}

void ficha_sube(void)
{
   ficha_f = ficha_f - 1;
}

void ficha_inc_tipo(void)
{
   ficha_tipo = (ficha_tipo + 1) % FICHA_TIPOS;         
}

void ficha_datos(void)
{
   gotoxy(0, 24);
   cprintf("E:%u, T:%u, R:%u, C:%u, F:%u     ", ficha_estado, ficha_tipo, ficha_rotacion, ficha_c, ficha_f);      
}

int ficha_color(int tipo)
{
   return tipo + 2;
}
