// PERMITIMOS MOVER LA FICHA EN LAS 4 DIRECCIONES CON EL JOYSTICK
// TAMBIEN ROTARLA A DERECHAS CON EL BOTON

#include <conio.h>
#include <joystick.h>
#include "tetris_ficha.h"
#include "tetris_joystick.h"

void inicializa(void);
void actualiza_ficha(void);
void retardo(unsigned int ret);

char joy2;

void main(void)
{
   inicializa();   
   
   while(1)
   {
      actualiza_ficha();      
      retardo(200);
   }
}

void inicializa(void)
{
   joystick_inicializa();

   clrscr();
   
   ficha_inicializa();
   ficha_pinta();      
}

void actualiza_ficha(void)
{
      joy2 = joystick_lee();
      
      if (JOY_LEFT(joy2))   
      {
         ficha_borra();      
         ficha_mueve_izquierda();
      }   
      else if (JOY_RIGHT(joy2))   
      {
         ficha_borra();      
         ficha_mueve_derecha();
      }   
      else if (JOY_UP(joy2))   
      {
         ficha_borra();      
         ficha_sube();
      }   
      else if (JOY_DOWN(joy2))   
      {
         ficha_borra();      
         ficha_baja();
      }   
      else if (JOY_BTN_1(joy2))   
      {
         ficha_borra();      
         ficha_rota_derecha();
      }   

      ficha_pinta();      
      ficha_datos();
}

void retardo(unsigned int ret)
{
   int i;
   
   for (i=0; i<ret; i++)
   {}
}
