#include <conio.h>
#include "tetris_ficha.h"

int fichas_def[][] = {
   {+0, +0, -1, +0, -1, -1, -1, +1},
   {+0, +0, -1, -1, +0, -1, +1, -1},
   {+0, +0, +1, -1, +1, +0, +1, +1},
   {+0, +0, -1, +1, +0, +1, +1, +1}
};

unsigned int ficha_estado;
unsigned int ficha_tipo;
unsigned int ficha_rotacion;
unsigned int ficha_x;
unsigned int ficha_y;
unsigned int ficha_color;

void ficha_inicializa(void)
{
   ficha_estado = 1;
   ficha_tipo = 0;
   ficha_rotacion = 0;
   ficha_x = 20;
   ficha_y = 12;
   ficha_color = 1;
}

void ficha_pinta(void)
{
   int i;
   int delta_x;
   int delta_y;
   
   for (i=0; i<8; i++)
   {
      delta_x = fichas_def[ficha_rotacion][i++];
      delta_y = fichas_def[ficha_rotacion][i];

      cputcxy(ficha_x + delta_x, ficha_y + delta_y, FICHA_CHAR);      
   }
}

void ficha_borra(void)
{
   int i;
   int delta_x;
   int delta_y;
   
   for (i=0; i<8; i++)
   {
      delta_x = fichas_def[ficha_rotacion][i++];
      delta_y = fichas_def[ficha_rotacion][i];

      cputcxy(ficha_x + delta_x, ficha_y + delta_y, FICHA_ESPACIO);      
   }
}

void ficha_rota_derecha(void)
{
   ficha_rotacion = (ficha_rotacion + 1) % 4;
}

void ficha_rota_izquierda(void)
{
   ficha_rotacion = (ficha_rotacion - 1) % 4;
}

void ficha_mueve_derecha(void)
{
   ficha_x = ficha_x + 1;
}

void ficha_mueve_izquierda(void)
{
   ficha_x = ficha_x - 1;
}

void ficha_baja(void)
{
   ficha_y = ficha_y + 1;
}

void ficha_sube(void)
{
   ficha_y = ficha_y - 1;
}

void ficha_datos(void)
{
   gotoxy(0, 24);
   cprintf("E:%u, T:%u, R:%u, X:%u, Y:%u, C:%u     ", ficha_estado, ficha_tipo, ficha_rotacion, ficha_x, ficha_y, ficha_color);      
}
