#include <stdio.h>

#define FORMATO_DDMMAA 1
#define FORMATO_AAMMDD 2

struct ddmmaa
{
   int dd;
   int mm;
   int aa;
};

typedef struct ddmmaa Fecha_ddmmaa;

struct aammdd
{
   int aa;
   int mm;
   int dd;
};

typedef struct aammdd Fecha_aammdd;

union fecha
{
   struct ddmmaa ddmmaa;
   struct aammdd aammdd;
};

typedef union fecha Fecha_xxxxxx;

void pinta_fecha(Fecha_xxxxxx *fecha, int formato);

void main(void)
{
   Fecha_ddmmaa mi_ddmmaa = {7, 5, 73};
   Fecha_aammdd mi_aammdd = {73, 5, 7};
   Fecha_xxxxxx mi_fecha;
   
   mi_fecha.ddmmaa = mi_ddmmaa;
   pinta_fecha(&mi_fecha, FORMATO_DDMMAA);

   mi_fecha.aammdd = mi_aammdd;
   pinta_fecha(&mi_fecha, FORMATO_AAMMDD);
   
   // El miembro almacenado en la unión todavía es aammdd
   // Si el programador no lo tiene claro e imprime con el formato contrario
   // la información no será correcta...
   pinta_fecha(&mi_fecha, FORMATO_DDMMAA);   
}

void pinta_fecha(Fecha_xxxxxx *mi_fecha, int formato)
{
   if (formato == FORMATO_DDMMAA)
      printf("DDMMAA = %d-%d-%d\n", mi_fecha->ddmmaa.dd, mi_fecha->ddmmaa.mm, mi_fecha->ddmmaa.aa);   
   else if (formato == FORMATO_AAMMDD)
      printf("AAMMDD = %d-%d-%d\n", mi_fecha->aammdd.aa, mi_fecha->aammdd.mm, mi_fecha->aammdd.dd);
}
