#include <stdio.h>

#define RET_CARRO_SI 1
#define RET_CARRO_NO 0

struct punto
{
   int x;
   int y;
};

struct rectangulo
{
   struct punto punto_a;
   struct punto punto_b;
};

struct punto crea_punto(int x, int y);
void pinta_punto(struct punto punto, int ret_carro);

void crea_rectangulo(struct punto punto_a, struct punto punto_b, struct rectangulo *prectangulo);
void pinta_rectangulo(struct rectangulo *prectangulo, int ret_carro);

void main(void)
{
   struct punto punto_1 = {10, 10};
   struct punto punto_2;
   struct rectangulo rectangulo;
   
   pinta_punto(punto_1, RET_CARRO_SI);
   
   punto_2 = punto_1;
   punto_2 = crea_punto(20, 20);
   pinta_punto(punto_2, RET_CARRO_SI);
   
   crea_rectangulo(punto_1, punto_2, &rectangulo);
   pinta_rectangulo(&rectangulo, RET_CARRO_SI);
   
   printf("%d\n", sizeof punto_2);
   printf("%d\n", sizeof(struct rectangulo));
}

struct punto crea_punto(int x, int y)
{
   struct punto punto;
   
   punto.x = x;
   punto.y = y;
   
   return punto;
}

void pinta_punto(struct punto punto, int ret_carro)
{
   printf("(%d, %d)", punto.x , punto.y);

   if (ret_carro)
      printf("\n");      
}

void crea_rectangulo(struct punto punto_a, struct punto punto_b, struct rectangulo *prectangulo)
{
   prectangulo->punto_a = punto_a;
   prectangulo->punto_b = punto_b;
}

void pinta_rectangulo(struct rectangulo *prectangulo, int ret_carro)
{
   pinta_punto(prectangulo->punto_a, RET_CARRO_NO);
   printf("-");
   pinta_punto(prectangulo->punto_b, RET_CARRO_NO);

   if (ret_carro)
      printf("\n");         
}
