#include <conio.h>
#include "sprites.h"
#include <c64.h>
#include <joystick.h>
#include <stdlib.h>

// Definición del sprite
byte def_sprite[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                     0x00,0x03,0x00,0xC0,0x00,0xC3,0x00,0x00,
                     0xC3,0x00,0x00,0xC3,0x00,0x00,0x28,0x00,
                     0x00,0xAA,0x00,0x00,0x69,0x00,0x00,0xAA,
                     0x00,0x3C,0xAA,0x3C,0x33,0x96,0xCC,0x30,
                     0xAA,0x0C,0x0C,0x28,0x30,0x0C,0x28,0x30,
                     0x0C,0x00,0x30,0x03,0x00,0xC0,0x03,0x00,
                     0xC0,0x03,0x00,0xC0,0x3F,0x00,0xFC,0x00};

byte num_sprite_0 = 0;
byte num_sprite_1 = 1;
   
byte bloque_0 = 254;
byte bloque_1 = 255;

int sprite0_x = 100;
int sprite0_y = 150;

int sprite1_x = 200;
int sprite1_y = 150;   

void inst_joy(void);
void conf_sprites(void);
void mueve_sprite_0(void);
void mueve_sprite_1(void);
void retardo(void);
void analiza_colision(void);

void main(void)
{
   // Limpia la pantalla
   clrscr();

   // Instala el driver del joystick
   inst_joy();
      
   // Hace la configuración inicial de los sprites 0 y 1
   conf_sprites();
   
   // Mueve los sprites y detecta las colisiones
   while (1)
   {
      mueve_sprite_0();
      analiza_colision();
      retardo();
      
      mueve_sprite_1();
      analiza_colision();
      retardo();      
   }
}

void inst_joy(void)
{
   int dri = 0;
   
   dri = joy_install(joy_static_stddrv);
   
   if (dri != 0)
   {
      exit(dri);
   }
}

void conf_sprites(void)
{
   // ***** CONFIGURACIÓN COMÚN A TODOS LOS SPRITES *****
   
   // Lee las colisiones para borrarlas
   byte col = VIC.spr_coll;
   
   // Configura los multicolores
   sprites_conf_multicolor(COLOR_BLACK, COLOR_YELLOW);
   
   // ***** CONFIGURACIÓN DEL SPRITE 0 *****
   
   // Copia la definición del sprite al bloque 0
   sprites_copia_def(def_sprite, bloque_0);
   
   // Hace la configuración básica del sprite 0
   sprites_conf_basica(num_sprite_0, bloque_0, COLOR_GREEN);

   // Hace la configuración avanzada del sprite 0
   sprites_conf_avanzada(num_sprite_0, SPRITES_MULTICOLOR_SI,
      SPRITES_EXP_X_NO, SPRITES_EXP_Y_NO, SPRITES_PRI_FONDO_SI);

   // Posiciona el sprite 0
   sprites_pos(num_sprite_0, sprite0_x, sprite0_y);

   // ***** CONFIGURACIÓN DEL SPRITE 1 *****
   
   // Copia la definición del sprite al bloque 1
   sprites_copia_def(def_sprite, bloque_1);
   
   // Hace la configuración básica del sprite 1
   sprites_conf_basica(num_sprite_1, bloque_1, COLOR_RED);

   // Hace la configuración avanzada del sprite 1
   sprites_conf_avanzada(num_sprite_1, SPRITES_MULTICOLOR_SI,
      SPRITES_EXP_X_NO, SPRITES_EXP_Y_NO, SPRITES_PRI_FONDO_SI);

   // Posiciona el sprite 1
   sprites_pos(num_sprite_1, sprite1_x, sprite1_y);
}

void mueve_sprite_0(void)
{
   byte joy_0 = joy_read(JOY_1);      
   
   if (JOY_UP(joy_0))
   {
      sprite0_y--;
   }
   else if (JOY_DOWN(joy_0))
   {
      sprite0_y++;
   }
   else if (JOY_LEFT(joy_0))
   {
      sprite0_x--;
   }
   else if (JOY_RIGHT(joy_0))
   {
      sprite0_x++;
   }
   
   sprites_pos(num_sprite_0, sprite0_x, sprite0_y);   
}

void mueve_sprite_1(void)
{
   byte joy_1 = joy_read(JOY_2);      
   
   if (JOY_UP(joy_1))
   {
      sprite1_y--;
   }
   else if (JOY_DOWN(joy_1))
   {
      sprite1_y++;
   }
   else if (JOY_LEFT(joy_1))
   {
      sprite1_x--;
   }
   else if (JOY_RIGHT(joy_1))
   {
      sprite1_x++;
   }
   
   sprites_pos(num_sprite_1, sprite1_x, sprite1_y);   
}

void retardo(void)
{
   int i;
   
   for (i=0; i<100; i++)
   {
   }
}

void analiza_colision(void)
{ 
   if(sprites_colision(num_sprite_0, num_sprite_1))
   {
      exit(-1);
   }
}
