#ifndef __SPRITES_H
#define __SPRITES_H

#define SPRITES_TAM 64
#define SPRITES_NUM 8

#define SPRITES_MULTICOLOR_SI 1
#define SPRITES_MULTICOLOR_NO 0

#define SPRITES_EXP_X_SI 1
#define SPRITES_EXP_X_NO 0

#define SPRITES_EXP_Y_SI 1
#define SPRITES_EXP_Y_NO 0

#define SPRITES_PRI_FONDO_SI 1
#define SPRITES_PRI_FONDO_NO 0

#define SPRITES_COL_SI 1
#define SPRITES_COL_NO 0

typedef unsigned char byte;

struct __sprites_punteros
{
   byte puntero[8];
};
   
#define SPRITES_PUNTEROS (*(struct __sprites_punteros*)0x07f8)

/* Copia la definición de un sprite (64 bytes) desde una dirección origen hasta otra de destino */
void sprites_copia_def(byte def_sprite[], byte bloque);

/* Configura los colores multicolor */
void sprites_conf_multicolor(byte multicolor_1, byte multicolor_2);

/* Hace la configuración básica de un sprite */
void sprites_conf_basica(byte num_sprite, byte bloque, byte color);

/* Posiciona un sprite */
void sprites_pos(byte num_sprite, int x, int y);

/* Hace la configuración avanzada de un sprite */
void sprites_conf_avanzada(byte num_sprite, byte multicolor, byte exp_x, byte exp_y, byte pri_fondo);

/* Detecta la colisión entre sprite 1 y 2 */
byte sprites_colision(byte num_sprite_1, byte num_sprite_2);

#endif
