#include "sprites.h"
#include <string.h>
#include <c64.h>

byte sprites_bit[] = {1, 2, 4, 8, 16, 32, 64, 128};

/* Copia la definición de un sprite (64 bytes) desde una dirección origen hasta otra de destino */
void sprites_copia_def(byte def_sprite[], byte bloque)
{
   int destino = bloque * SPRITES_TAM;
   memcpy(destino, def_sprite, SPRITES_TAM);
}

/* Configura los colores multicolor */
void sprites_conf_multicolor(byte multicolor_0, byte multicolor_1)
{
   VIC.spr_mcolor0 = multicolor_0;
   VIC.spr_mcolor1 = multicolor_1;   
}

/* Hace la configuración básica de un sprite */
void sprites_conf_basica(byte num_sprite, byte bloque, byte color)
{
   // Configura el puntero del sprite
   SPRITES_PUNTEROS.puntero[num_sprite] = bloque;
   
   // Configura el color del sprite
   VIC.spr_color[num_sprite] = color;
   
   // Activa el sprite
   VIC.spr_ena = VIC.spr_ena | sprites_bit[num_sprite];
}

/* Posiciona un sprite */
void sprites_pos(byte num_sprite, int x, int y)
{
   // Fija la coordenada x
   VIC.spr_pos[num_sprite].x = x;
   
   // Fija la coordenada y
   VIC.spr_pos[num_sprite].y = y;   
}

/* Hace la configuración avanzanda de un sprite */
void sprites_conf_avanzada(byte num_sprite, byte multicolor, byte exp_x, byte exp_y, byte pri_fondo)
{
   // Activa o desactiva el multicolor
   if (multicolor)
   {
      VIC.spr_mcolor = VIC.spr_mcolor | sprites_bit[num_sprite];
   }
   else
   {
      VIC.spr_mcolor = VIC.spr_mcolor & ~(sprites_bit[num_sprite]);   
   }
   // Activa o desactiva la expansión x
   if (exp_x)
   {
      VIC.spr_exp_x = VIC.spr_exp_x | sprites_bit[num_sprite];
   }
   else
   {
      VIC.spr_exp_x = VIC.spr_exp_x & ! ~(sprites_bit[num_sprite]);   
   }
      
   // Activa o desactiva la expansión y
   if (exp_y)
   {
      VIC.spr_exp_y = VIC.spr_exp_y | sprites_bit[num_sprite];
   }
   else
   {
      VIC.spr_exp_y = VIC.spr_exp_y & ! ~(sprites_bit[num_sprite]);   
   }
   
   // Fija la prioridad respecto al fondo
   if (pri_fondo)
   {
      VIC.spr_bg_prio = VIC.spr_bg_prio | sprites_bit[num_sprite];
   }
   else
   {
      VIC.spr_bg_prio = VIC.spr_bg_prio & ~(sprites_bit[num_sprite]);   
   }   
}

/* Detecta la colisión entre sprite 1 y 2 */
byte sprites_colision(byte num_sprite_1, byte num_sprite_2)
{
   byte colisiones = 0;
   
   // Lee el registro de colisiones sprite - sprite (se borra)
   colisiones = VIC.spr_coll;
   
   // Mira si el bit correspondiente al sprite 1 está activo
   if ((colisiones & sprites_bit[num_sprite_1]) == 0)
   {
      return SPRITES_COL_NO;
   }
   
   // Mira si el bit correspondiente al sprite 2 está activo
   if ((colisiones & sprites_bit[num_sprite_2]) == 0)
   {
      return SPRITES_COL_NO;
   }
   
   // Si ambos bits están activos tenemos colisión...
   return SPRITES_COL_SI;
}
