#include "sonido.h"
#include <stdio.h>

// Melodía con 3 voces
// Libro De Jong páginas 198-199
byte tabla_melodia[] = {
         0x40,0x40,0x50,0x4f,0x35,0x30,0x45,0x6f,
         0x35,0x30,0x47,0x2f,0x35,0x30,0x49,0x4e,
         0x39,0x35,0x45,0x4f,0x37,0x34,0x40,0x6f,
         0x35,0x32,0x40,0x2f,0x37,0x34,0x40,0x4f,
         0x39,0x34,0x40,0x4f,0x35,0x49,0x45,0x6f,
         0x35,0x49,0x45,0x2f,0x39,0x35,0x45,0x4f,
         0x20,0x35,0x45,0x4f,0x22,0x35,0x4a,0xcf,
         0x22,0x35,0x4a,0x4f,0x20,0x35,0x49,0x6f,
         0x39,0x35,0x45,0x2f,0x39,0x35,0x45,0x4f,
         0x35,0x49,0x45,0x4f,0x37,0x34,0x40,0x6f,
         0x35,0x32,0x40,0x2f,0x37,0x34,0x40,0x4f,
         0x39,0x34,0x40,0x4f,0x35,0x32,0x45,0x6f,
         0x32,0x49,0x42,0x2f,0x32,0x4a,0x5a,0x4f,
         0x30,0x4a,0x40,0x4f,0x35,0x49,0x55,0xcf,
         0x45,0x35,0x22,0x4f,0x45,0x35,0x20,0x6f,
         0x40,0x30,0x39,0x2f,0x45,0x35,0x39,0x4f,
         0x59,0x35,0x69,0x4f,0x40,0x34,0x37,0x6f,
         0x40,0x32,0x35,0x2f,0x40,0x34,0x37,0x4f,
         0x40,0x34,0x22,0x4f,0x45,0x35,0x20,0x6f,
         0x40,0x30,0x39,0x2f,0x45,0x35,0x39,0x4f,
         0x49,0x30,0x59,0x4e,0x4a,0x35,0x32,0xcf,
         0x4a,0x35,0x25,0x4f,0x49,0x35,0x20,0x6f,
         0x45,0x35,0x39,0x2f,0x45,0x35,0x39,0x4f,
         0x59,0x30,0x35,0x4f,0x40,0x34,0x37,0x6f,
         0x40,0x32,0x35,0x2f,0x40,0x34,0x37,0x4f,
         0x41,0x34,0x39,0x2f,0x41,0x49,0x37,0x2f,
         0x42,0x32,0x35,0x6c,0x45,0x49,0x32,0x2c,
         0x5a,0x4a,0x32,0x4d,0x40,0x44,0x30,0x4f,
         0x55,0x45,0x35,0xff,0x55,0x45,0x35,0xc0,
         0xff};

void configura_voces(void);
void configura_voz_0(void);
void configura_voz_1(void);
void configura_voz_2(void);
void reproduce_melodia(void);
void configura_frecuencia(byte octava_nota, byte voz);
byte configura_volumen(byte duracion_volumen);

void main(void)
{
   // Configura las voces
   configura_voces();
   
   // Pinta las cabeceras
   printf("voz-oct-nota-frec\n");
   printf("voz-oct-nota-frec\n");
   printf("voz-oct-nota-frec\n");
   printf("dur-vol\n\n");         
   
   // Reproduce la melodía
   reproduce_melodia();
}

void configura_voces(void)
{
   // Inicializa el SID
   sonido_inicializa_imagen();
   sonido_transfiere_imagen();
   
   // Configura las 3 voces
   configura_voz_0();
   configura_voz_1();   
   configura_voz_2();
}

void configura_voz_0(void)
{
   sonido_fija_forma_onda(SONIDO_FO_TRIANGULAR, SONIDO_VOZ_0);
   sonido_fija_adsr(3, 1, 11, 1, SONIDO_VOZ_0);
}

void configura_voz_1(void)
{
   sonido_fija_forma_onda(SONIDO_FO_RAMPA, SONIDO_VOZ_1);
   sonido_fija_adsr(8, 3, 10, 3, SONIDO_VOZ_1);
}
   
void configura_voz_2(void)
{
   sonido_fija_forma_onda(SONIDO_FO_CUADRADA, SONIDO_VOZ_2);
   sonido_fija_ancho_pulso(0x0900, SONIDO_VOZ_2);   
   sonido_fija_adsr(3, 8, 4, 8, SONIDO_VOZ_2);
}

void reproduce_melodia(void)
{
   unsigned int i;
   byte octava_nota;
   byte duracion_volumen;
   byte duracion;
   
   for (i = 0; ;)
   {
      // Voz 0
      octava_nota = tabla_melodia[i];
      if (octava_nota == 0xFF)
         break;
      configura_frecuencia(octava_nota, SONIDO_VOZ_0);      
      i++;
      
      // Voz 1
      octava_nota = tabla_melodia[i];      
      configura_frecuencia(octava_nota, SONIDO_VOZ_1);
      i++;
      
      // Voz 2
      octava_nota = tabla_melodia[i];      
      configura_frecuencia(octava_nota, SONIDO_VOZ_2);
      i++;

      // Volumen
      duracion_volumen = tabla_melodia[i];      
      duracion = configura_volumen(duracion_volumen);
      i++;
      
      // Activa las 3 voces
      sonido_activa_voz(0);
      sonido_activa_voz(1);
      sonido_activa_voz(2);

      // Transfiere la imagen al SID
      sonido_transfiere_imagen();
      
      // Espera la duración
      duracion_nota(duracion, 100);
/*      
      // Desactiva las 3 voces
      sonido_desactiva_voz(0);
      sonido_desactiva_voz(1);
      sonido_desactiva_voz(2);

      // Transfiere la imagen al SID
      sonido_transfiere_imagen();            
*/      
   }
   
   // Desactiva las 3 voces
   sonido_desactiva_voz(0);
   sonido_desactiva_voz(1);
   sonido_desactiva_voz(2);

   // Transfiere la imagen al SID
   sonido_transfiere_imagen();            
}

void configura_frecuencia(byte octava_nota, byte voz)
{
   byte octava;
   byte nota;
   unsigned int frecuencia;
   
   printf("%0*X-", 2, voz);
   
   octava = (octava_nota & 0xF0) >> 4;
   printf("%0*X-", 2, octava);
   
   nota = octava_nota & 0x0F;
   printf("%0*X-", 2, nota);   
   
   frecuencia = sonido_obten_frecuencia(octava, nota);
   printf("%0*X\n", 4, frecuencia);
   
   sonido_fija_frecuencia(frecuencia, voz);
}

byte configura_volumen(byte duracion_volumen)
{
   byte duracion;
   byte volumen;
   
   duracion = (duracion_volumen & 0xF0) >> 4;
   printf("%0*X-", 2, duracion);
   
   volumen = duracion_volumen & 0x0F;
   printf("%0*X\n", 2, volumen);
   
   sonido_fija_volumen(volumen);
   
   return duracion;
}

