#ifndef __SONIDO_H
#define __SONIDO_H

#define SONIDO_TAM_IMAGEN 25

#define SONIDO_VOZ_0 0
#define SONIDO_VOZ_1 1
#define SONIDO_VOZ_2 2

#define SONIDO_FO_TRIANGULAR 16
#define SONIDO_FO_RAMPA 32
#define SONIDO_FO_CUADRADA 64
#define SONIDO_FO_RUIDO 128

#define SONIDO_FILTRO_PBAJO 16
#define SONIDO_FILTRO_PBANDA 32
#define SONIDO_FILTRO_PALTO 64

typedef unsigned char byte;

/* Inicializa la imagen del SID */
void sonido_inicializa_imagen(void);

/* Pinta la imagen del SID (para depuración) */
void sonido_pinta_imagen(void);

/* Transfiere la imagen del SID al SID */
void sonido_transfiere_imagen(void);

/* Fija el volumen */
void sonido_fija_volumen(byte volumen);

/* Fija la frecuencia de una voz */
void sonido_fija_frecuencia(unsigned int frecuencia, byte voz);

/* Fija la forma de onda de una voz */
void sonido_fija_forma_onda(byte forma_onda, byte voz);

/* Fija el ADSR de una voz */
void sonido_fija_adsr(byte attack, byte decay, byte sustain, byte release, byte voz);

/* Fija el ancho de pulso de una voz (si forma cuadrada) */
void sonido_fija_ancho_pulso(unsigned int ancho_pulso, byte voz);

/* Configura un filtro para una voz */
void sonido_configura_filtro(byte tipo, unsigned int frecuencia, byte voz);

/* Activa una voz */
void sonido_activa_voz(byte voz);

/* Desactiva una voz */
void sonido_desactiva_voz(byte voz);

/* Devuelve la frecuencia a partir de la octava y la nota */
unsigned int sonido_obten_frecuencia(byte octava, byte nota);

/* Mete un retardo para la nota */
void duracion_nota(byte iteraciones, byte milisegundos);

#endif
