#include "sonido.h"
#include <string.h>
#include <stdio.h>
#include <c64.h>

static byte sonido_imagen_sid[SONIDO_TAM_IMAGEN];
static byte sonido_offset_voces[] = {0x00, 0x07, 0x0E};
static unsigned int sonido_frecuencias_oct7[] = {0x861E, 0x8E18, 0x968B, 0x9F7E, 0xA8FA, 0xB306,
                                                 0xBDAC, 0xC8F3, 0xD4E6, 0xE18F, 0xEEF8, 0xFD2E};

/* Inicializa la imagen del SID */
void sonido_inicializa_imagen(void)
{
   byte i = 0;
   
   for (i = 0; i < SONIDO_TAM_IMAGEN; i++)
   {
      sonido_imagen_sid[i] = 0;
   }
}

/* Pinta la imagen del SID (para depuración) */
void sonido_pinta_imagen(void)
{
   byte i = 0;
   
   for (i = 0; i < SONIDO_TAM_IMAGEN; i++)
   {
      printf("%X", sonido_imagen_sid[i]);
      if (i < (SONIDO_TAM_IMAGEN-1))
      {
         printf("-");
      }
      else
      {
         printf("\n");      
      }
   }
}

/* Transfiere la imagen del SID al SID */
void sonido_transfiere_imagen(void)
{
   unsigned int destino = 0xD400;
   memcpy((void*) destino, sonido_imagen_sid, SONIDO_TAM_IMAGEN);
}

/* Fija el volumen */
void sonido_fija_volumen(byte volumen)
{
   volumen = volumen & 0x0F;
   sonido_imagen_sid[0x18] = sonido_imagen_sid[0x18] | volumen;
}

/* Fija la frecuencia de una voz */
void sonido_fija_frecuencia(unsigned int frecuencia, byte voz)
{
   byte offset = sonido_offset_voces[voz];
   
   sonido_imagen_sid[0x00+offset] = frecuencia & 0x00FF;
   sonido_imagen_sid[0x01+offset] = frecuencia >> 8;
}

/* Fija la forma de onda de una voz */
void sonido_fija_forma_onda(byte forma_onda, byte voz)
{
   byte offset = sonido_offset_voces[voz];

   forma_onda = forma_onda & 0xF0;
   sonido_imagen_sid[0x04+offset] = sonido_imagen_sid[0x04+offset] | forma_onda;
}

/* Fija el ADSR de una voz */
void sonido_fija_adsr(byte attack, byte decay, byte sustain, byte release, byte voz)
{
   byte offset = sonido_offset_voces[voz];
   byte attack_decay;
   byte sustain_release;
   
   attack = (attack & 0x0F) << 4;
   decay = (decay & 0x0F);
   attack_decay = attack | decay;
   
   sonido_imagen_sid[0x05+offset] = attack_decay;
   
   sustain = (sustain & 0x0F) << 4;
   release = (release & 0x0F);
   sustain_release = sustain | release;
   
   sonido_imagen_sid[0x06+offset] = sustain_release;   
}

/* Fija el ancho de pulso de una voz (si forma cuadrada) */
void sonido_fija_ancho_pulso(unsigned int ancho_pulso, byte voz)
{
   byte offset = sonido_offset_voces[voz];
   ancho_pulso = ancho_pulso & 0x0FFF;
   
   sonido_imagen_sid[0x02+offset] = ancho_pulso & 0x00FF;
   sonido_imagen_sid[0x03+offset] = ancho_pulso >> 8;
}

/* Configura un filtro para una voz */
void sonido_configura_filtro(byte tipo, unsigned int frecuencia, byte voz)
{
   tipo = tipo & 0x70;
   sonido_imagen_sid[0x18] = sonido_imagen_sid[0x18] | tipo;
   
   frecuencia = frecuencia & 0x03FF;
   sonido_imagen_sid[0x15] = frecuencia & 0x0007;
   sonido_imagen_sid[0x16] = frecuencia >> 3;

   switch(voz)
   {
      case 0:
         sonido_imagen_sid[0x17] = sonido_imagen_sid[0x17] | 0x01;
         break;
      case 1:
         sonido_imagen_sid[0x17] = sonido_imagen_sid[0x17] | 0x02;      
         break;
      case 2:
         sonido_imagen_sid[0x17] = sonido_imagen_sid[0x17] | 0x04;            
         break;
   }
}

/* Activa una voz */
void sonido_activa_voz(byte voz)
{
   byte offset = sonido_offset_voces[voz];
   
   sonido_imagen_sid[0x04+offset] = sonido_imagen_sid[0x04+offset] | 0x01;
}

/* Desactiva una voz */
void sonido_desactiva_voz(byte voz)
{
   byte offset = sonido_offset_voces[voz];
   
   sonido_imagen_sid[0x04+offset] = sonido_imagen_sid[0x04+offset] & 0xFE;
}

/* Devuelve la frecuencia a partir de la octava y la nota */
unsigned int sonido_obten_frecuencia(byte octava, byte nota)
{
   unsigned int frecuencia = sonido_frecuencias_oct7[nota];
   byte num_divisiones = 7 - octava;
   byte i;
   
   for (i = 0; i < num_divisiones; i++)
   {
      frecuencia = frecuencia / 2;
   }
   
   return frecuencia;
}

/* Mete un retardo */
void duracion_nota(byte iteraciones, byte milisegundos)
{
   int i;
   int j;
   
   for (i = 0; i < iteraciones; i++)
   {
      for (j = 0; j < milisegundos; j++)
      {
      }
   }
}
