#include <c64.h>
#include <string.h>
#include <sprite3.h>

// Definición del sprite
unsigned char def_sprite[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                              0x00,0x01,0x00,0x80,0x00,0x81,0x00,0x00,
                              0x42,0x00,0x00,0x42,0x00,0x00,0x5A,0x00,
                              0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x5A,
                              0x00,0x06,0x7E,0x60,0x05,0x7E,0xA0,0x04,
                              0xFF,0x20,0x02,0x7E,0x40,0x02,0x3C,0x40,
                              0x02,0x18,0x40,0x01,0x00,0x80,0x01,0x00,
                              0x80,0x01,0x00,0x80,0x1F,0x00,0xF8,0x00};                           

void copia_def_sprite(unsigned char origen[], unsigned char bloque);
void conf_ptr_sprite(unsigned char sprite, unsigned char bloque);

void main(void)
{
   unsigned char sprite = 0;
   unsigned char bloque = 254;
   
   // Copia la definición del sprite al bloque
   copia_def_sprite(def_sprite, bloque);
   
   // Configura el puntero del sprite para apuntar al bloque
   conf_ptr_sprite(sprite, bloque);
                  
   // Activa el sprite
   VIC.spr_ena = 1;
   
   // Fija el color del sprite
   VIC.spr_color[sprite] = 0x0d;
   
   // Posiciona el sprite
   VIC.spr_pos[sprite].x = 183;
   VIC.spr_pos[sprite].y = 150;
}

void copia_def_sprite(unsigned char origen[], unsigned char bloque)
{
   int dest = 0;
   
   dest = bloque * 64;
   memcpy(dest, origen, 64);
}

void conf_ptr_sprite(unsigned char sprite, unsigned char bloque)
{
   switch (sprite)
   {
      case 0:
         SPR_PTR.spr0_ptr = bloque;
         break;
      case 1:
         SPR_PTR.spr1_ptr = bloque;
         break;
      case 2:
         SPR_PTR.spr2_ptr = bloque;
         break;
      case 3:
         SPR_PTR.spr3_ptr = bloque;
         break;
      case 4:
         SPR_PTR.spr4_ptr = bloque;
         break;
      case 5:
         SPR_PTR.spr5_ptr = bloque;
         break;
      case 6:
         SPR_PTR.spr6_ptr = bloque;
         break;
      case 7:
         SPR_PTR.spr7_ptr = bloque;
         break;     
   }
}
