#include <c64.h>
#include <string.h>

// Definición del sprite
unsigned char def_sprite[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                              0x00,0x01,0x00,0x80,0x00,0x81,0x00,0x00,
                              0x42,0x00,0x00,0x42,0x00,0x00,0x5A,0x00,
                              0x00,0x3C,0x00,0x00,0x7E,0x00,0x00,0x5A,
                              0x00,0x06,0x7E,0x60,0x05,0x7E,0xA0,0x04,
                              0xFF,0x20,0x02,0x7E,0x40,0x02,0x3C,0x40,
                              0x02,0x18,0x40,0x01,0x00,0x80,0x01,0x00,
                              0x80,0x01,0x00,0x80,0x1F,0x00,0xF8,0x00};                           

void copia_def_sprite(unsigned char origen[], unsigned char bloque);
void conf_ptr_sprite(unsigned char sprite, unsigned char bloque);

void main(void)
{
   unsigned char sprite = 0;
   unsigned char bloque = 254;
   
   // Copia la definición del sprite al bloque
   copia_def_sprite(def_sprite, bloque);
   
   // Configura el puntero del sprite para apuntar al bloque
   conf_ptr_sprite(sprite, bloque);
                  
   // Activa el sprite
   VIC.spr_ena = 1;
   
   // Fija el color del sprite
   VIC.spr0_color = 0x0d;
   
   // Posiciona el sprite
   VIC.spr0_x = 183;
   VIC.spr0_y = 150;
}

void copia_def_sprite(unsigned char origen[], unsigned char bloque)
{
   int dest = 0;
   
   dest = bloque * 64;
   memcpy(dest, origen, 64);
}

void conf_ptr_sprite(unsigned char sprite, unsigned char bloque)
{
   int dest = 0;
   
   dest = 0x07f8 + sprite;   
   memcpy(dest, &bloque, 1);
}
