#include <c64.h>
#include <conio.h>
#include <mouse.h>
#include <stdio.h>

void error_driver(char dri);
void pinta_mouse(struct mouse_pos* pos);

int main(void)
{  
   char dri = 0;
   struct mouse_pos pos;
   
   // Borra la pantalla
   clrscr();

   // Instala el driver
   dri = mouse_install(&mouse_def_callbacks, mouse_static_stddrv);
   
   if (dri != 0)
   {
      error_driver(dri);
      return dri;
   }

   // Entra en un bucle infinito
   while (1)
   {
      // Lee el mouse
      mouse_pos(&pos);
      
      // Pinta la lectura
      pinta_mouse(&pos);
   }
}

void error_driver(char dri)
{
      cputsxy(0, 0, "ERROR AL INSTALAR EL DRIVER:");

      if (dri == MOUSE_ERR_NO_DRIVER)
      {
         cputsxy(0, 1, "No driver available");      
      }
      else if (dri == MOUSE_ERR_CANNOT_LOAD)
      {
         cputsxy(0, 1, "Error loading driver");      
      }
      else if (dri == MOUSE_ERR_INV_DRIVER)
      {
         cputsxy(0, 1, "Invalid driver");      
      }
      else if (dri == MOUSE_ERR_NO_DEVICE)
      {
         cputsxy(0, 1, "Mouse hardware not found");      
      }
      else if (dri == MOUSE_ERR_INV_IOCTL)
      {
         cputsxy(0, 1, "Invalida ioctl code");      
      }      
}

void pinta_mouse(struct mouse_pos* pos)
{
   gotoxy(0, 0);
   printf("X: %i   \n", pos->x);
   printf("Y: %i   \n", pos->y);   
}
